#include<stdio.h>
#include<stdlib.h>
#include<string.h>

int main(int argc, char *tt[]){

int e; //exponent
int d;  //length of the word
int i,j,k,x,y;
int max = 1000;
double w,v;
int dd[max][max]; //dd[i][j] = biinvariant length of the word t[i]...t[j]
int t[max];
char z;

if(argc!=3) {
        printf("Usage: biinv.length.out exponent word\n");
        return 0;
}

e = atoi(tt[1]);
d = strlen(tt[2]);

if(d*e > 999) { 
	printf("Length of word^exponent cannot excede 1000.\n");
	return 0;
} 

//digitilize
for (j=0;j<d;j++) {
	z = tt[2][j];
	if(z == 'a') t[j] = 1;
	if(z == 'A') t[j] = -1;
	if(z == 'b') t[j] = 2;
	if(z == 'B') t[j] = -2;
}

//t <- word^exponent
for(j=1;j<e;j++){
	for(i=0;i<d;i++) t[j*d+i] = t[i];
}

//initial values for dd
for(j=0;j<e*d;j++) {
	dd[j][j] = 1;	
	dd[j+1][j] = 0;
}

//computing the biiinvariant length of the subwords t[i][x]
for (j=2; j<e*d+1;j++){ // j = length of subwords whose biinv. length is computed
	for(i=0;i<e*d-j+1;i++){
		x = i+j-1;
		dd[i][x]=dd[i][x-1]+1;
		
		for(k=0;k<j-1;k++) {
			if (t[i+k]+t[x] == 0){ 
				if (k > 0)  y = dd[i][i+k-1]+dd[i+k+1][x-1];
				else y = dd[i+1][x-1];
				if (y < dd[i][x]) dd[i][x] = y;
				}
		}   	
	}
}

w = (float)dd[0][d*e-1]/(float)(dd[0][d-1]*e);
v = (float)dd[0][d*e-1]/(float)(d*e);

printf("\n");
printf("Word:................................... %s\n",tt[2]);
printf("Exponent:............................... %d\n",e);
printf("Biinvariant length of the Word:......... %d\n",dd[0][d-1]);
printf("Biinvariant length of the Word^Exponent: %d\n",dd[0][d*e-1]);
printf("Distorsion:............................. %.2f\n",w);
printf("Biinvariant vs. normal length:.......... %.2f\n",v);
printf("\n");

return 0;
}
