#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>

struct TkursAkcji
{
   int nD;
   double w;
};

/* Notowania KGHM z
  http://www.gpwinfostrefa.pl
*/
const char *naFin   = "PLKGHM000017.csv";
const char *naFout  = "dane.dat";
const int nrPola    = 9;
const char *naFhist = "hist.txt";

/* *Data - postaci yyyy-mm-dd
 * *nD   - ilosc dni jakie uplynely
 *         od 1970-01-01
 */
int getDays(int *nD,char *Data)
{
   char buf[15],*ws;
   struct tm stT;

   strncpy(buf,Data,10);
   *(buf+10) = '\0';
   memset(&stT,0,sizeof(struct tm));
   stT.tm_hour = 1;
   for(ws=strpbrk(buf," \r\t\n"); ws!=NULL; ws=strpbrk(buf," \r\t\n"))
   {
      strcpy(ws,ws+1);
   }
   if( *(buf+4)!='-' || *(buf+7)!='-' )
   {
      return -1;
   }
   *(buf+4) = *(buf+7) = '\0';
   stT.tm_year = strtol(buf,NULL,10)-1900;
   if( stT.tm_year<70 || 137<stT.tm_year)
   {
      return -1;
   }
   stT.tm_mon  = strtol(buf+5,NULL,10)-1;
   stT.tm_mday = strtol(buf+8,NULL,10);
   *nD = mktime( &stT )/86400L;
   return 0;
}

/* nD - ilosc dni jakie uplynely od
 *      1970-01-01
 * funkcja zwraca date postaci:
 *      dd-mm-yyyy
 */
char *strDate(int nD)
{
   static char M[12];
   struct tm stT;
   time_t T;

   T = nD*86400L;
   memmove(&stT, localtime(&T), sizeof(struct tm));
   strftime(M, 11, "%d-%m-%Y", &stT);
   return M;
}

struct TkursAkcji kursRef[2]={{0,0.0},{0,0.0}};

/* strategia inwestowania */
int stratInvest(struct TkursAkcji *kursDec, int n, struct TkursAkcji kursAkt)
{
   if( 1<n && kursRef[0].w!=kursRef[1].w )
   {
      if( fabs(kursRef[1].w-kursAkt.w)<0.000001 )
      {
         return 0;
      }
      if( (kursRef[0].w<kursRef[1].w && kursRef[1].w<kursAkt.w) || (kursAkt.w<kursRef[1].w && kursRef[1].w<kursRef[0].w) )
      {
         kursRef[1].nD = kursAkt.nD;
         kursRef[1].w  = kursAkt.w;
         return 0;
      }
      kursDec->nD   = kursRef[0].nD;
      kursDec->w    = kursRef[0].w;
      kursRef[0].nD = kursRef[1].nD;
      kursRef[0].w  = kursRef[1].w;
      kursRef[1].nD = kursAkt.nD;
      kursRef[1].w  = kursAkt.w;
      return (kursDec->w < kursRef[0].w ? 1 : -1);
   }
   if( n==0 )
   {
      kursRef[0].nD = kursAkt.nD;
      kursRef[0].w  = kursAkt.w;
      return 0;
   }
   kursRef[1].nD = kursAkt.nD;
   kursRef[1].w  = kursAkt.w;
// pierwsze kupno
   if( kursRef[0].w<kursRef[1].w )
   {
      kursDec->nD = kursRef[0].nD;
      kursDec->w  = kursRef[0].w;
      return 1;
   }
   return 0;
}

int main()
{
   struct TkursAkcji kursDec,kursAkt;
   double kasa;
   char M[1025],*wr,*ws;
   FILE *fFin,*fFout,*fFhist;
   int dec,i,n;

   kasa = 1.0;
   fFin = fopen(naFin, "r");
   if( fFin==NULL )
   {
      perror(naFin);
      exit(-1);
   }
   fFout  = fopen(naFout,  "w");
   fFhist = fopen(naFhist, "w");
   fprintf(fFhist,"Inwestujemy: %6.2lf PLN\n\n              kurs     PLN akcje\n",kasa);
   fgets(M,1024,fFin);
   n = 0;
   while( fgets(M,1024,fFin)!=NULL )
   {
      if( (wr=strpbrk(M,"\r\n"),wr)!=NULL )
      {
         *wr = '\0';
      }
      wr  = strchr(M,';')+1;
      ws  = strchr(wr,';');
      *ws = '\0';
      if( getDays(&kursAkt.nD, wr)!=0 )
      {
         continue;
      }
      for(i=2; i<nrPola; i=i+1)
      {
         wr = ws+1;
         ws = strchr(wr, ';');
         *ws = '\0';
      }
      if( (ws=strchr(wr,','),ws)!=NULL )
      {
         *ws = '.';
      }
      kursAkt.w = strtod(wr, NULL);
      fprintf(fFout, "%s\t%6.2lf\n", strDate(kursAkt.nD), kursAkt.w);
      dec = stratInvest(&kursDec, n, kursAkt);
      if( dec!=0 )
      {
         if( 0<dec )
         {
            kasa = -kasa/kursDec.w;
            fprintf(fFhist,"%s  %6.2lf        %6.2lf\n", strDate(kursDec.nD), kursDec.w, -kasa);
         }
         else
         {
            if( kasa<=0.0 )
            {
               kasa = -kasa*kursDec.w;
               fprintf(fFhist,"%s  %6.2lf  %6.2lf\n", strDate(kursDec.nD), kursDec.w, kasa);
            }
         }
      }
      n = n+1;
      if( 10.0<kasa )
      {
         break;
      }
   }
   fclose(fFhist);
   fclose(fFout);
   fclose(fFin);
   printf("ilosc notowan: %i\n        wynik: %6.2lf\n", n, kasa);
/* - */
   if( system("gnuplot -persist wykres.cmd")==-1 )
   {
      perror("\"gnuplot\"");
   }
/* - */
   return 0;
}
