#include "rsaLib.h"
#include <sys/types.h>
#include <sys/stat.h>       
#include <time.h>
#include <string.h>
#include <time.h>

void sitoE(int *n,unsigned short int **tabLP,int N)
{
   unsigned short int *a;
   int i,j;

   a = (unsigned short int *)malloc((N+1)*sizeof(unsigned short int));
   for(i=0; i<=N; i=i+1)
      a[i] = i;
   for(i=2; i<=N; i=i+1)
   {
      if( !a[i] )
         continue; 
      for(j=2; j*a[i]<=N; j=j+1)
         a[j*a[i]] = 0;
   }
   *tabLP = NULL;
   *n     = 0;
   for(i=2; i<=N; i=i+1)
   {
      if( a[i] )
      {
         *tabLP = (unsigned short int *)realloc(*tabLP,(*n+1)*sizeof(unsigned short int));
         (*tabLP)[*n] = a[i];
         *n = *n+1;         
      }
   }
   free(a);
}
//-----------------------------------------------------------------------------

unsigned int NWD(unsigned int m,unsigned int n)
{
   unsigned int r;

   if(m==0 || n==0)
   {
      puts("Error w NWD()");
      exit(-1);
   }
   do {
         r = n%m;
         n = m;
         m = r;
      } while( r );
   return n;
}
//-----------------------------------------------------------------------------

/* 
   Czy aby ta procedura wyboru p,q jest poprawna !?
*/
void wyborPQ(int *p,int *q,int n,unsigned short int *tabLP)
{
   int i,k;

   srandom( time(NULL) );
   k = n/2;
   *p = tabLP[ k+random()%k ];
   i = 0;
   do {
         if( 100<i )
         {
            puts("Error w funkcji pq()");
            exit(-2);
         }
         *q = tabLP[ k+random()%k ];
         i = i+1;
      } while( *p==*q );
}
//-----------------------------------------------------------------------------

/*
   grupa multiplikatywna $Z^*_N$
*/
void gpaZ(int *n,unsigned int **Z,int N)
{
   int i;

   *Z = NULL;
   *n = 0;
   for(i=1; i<N; i=i+1)
   {
      if( NWD(i,N)==1 )
      {
         *Z = (unsigned int *)realloc(*Z,(*n+1)*sizeof(unsigned int));
         (*Z)[*n] = i;
         *n = *n+1;
      }
   }
}
//-----------------------------------------------------------------------------

/* 
   Czy zawsze uda sie wybrac E !?
*/
void wyborE(int *e,int fi)
{
   int i;

   srandom( time(NULL) );
   i = 0;
   do {
         if( 100<i )
         {
            puts("Error w funkcji wyborE()");
            exit(-3);
         }
         *e = 2*(random()%50)+11;
         i = i+1;
      } while( NWD(*e,fi)!=1 );
}
//-----------------------------------------------------------------------------

void obliczD(int *d,int e,int fi,int n)
{
   for(*d=1; *d<n; *d=*d+1)
   {
      if( ((long long)*d * (long long)e-1ll)%(long long)fi==0ll )
         return;
   }
   puts("Error w funkcji obliczD()");
   exit(-4);
}
//-----------------------------------------------------------------------------
/*
   Moze zastosowac algorytm "square-and-multiply" z listy Nr 03, lab ?
*/

unsigned int P(unsigned int M,int e,int n)
{
   unsigned long long int w;
   int i; 
   
   w = 1.0;
   for(i=0; i<e; i=i+1)
      w = (w*M)%n;
   return (unsigned int)w;
}
//-----------------------------------------------------------------------------

void zapiszKlucz(char *naF,int e,int n)
{
   FILE *fF;

   fF = fopen(naF,"w");
   if( fF==NULL )
   {
      perror(naF);
      exit(-6);
   }
   fprintf(fF,"%i\n",e);
   fprintf(fF,"%i\n",n);
   fclose( fF );
}
//-----------------------------------------------------------------------------

void czytajKlucz(char *naF,int *e,int *n)
{
   char M[81],*ws;
   FILE *fF;

   fF = fopen(naF,"r");
   if( fF==NULL )
   {
      perror(naF);
      exit(-7);
   }
   if( fgets(M,80,fF)==NULL )
   {
      printf("Error: \"%s\" - blad danych\n",naF);
      exit(-8);
   }
   ws = strpbrk(M,"\r\t\n\f");
   if( ws!=NULL )
      *ws = '\0';
   *e = strtol(M, &ws, 10);
   if( *ws!='\0' || fgets(M,80,fF)==NULL )
   {
      printf("Error: \"%s\" - blad danych\n",naF);
      exit(-9);
   }
   ws = strpbrk(M,"\r\t\n\f");
   if( ws!=NULL )
      *ws = '\0';
   *n = strtol(M, &ws, 10);
   if( *ws!='\0' )
   {
      printf("Error: \"%s\" - blad danych\n",naF);
      exit(-10);
   }
   fclose( fF );
}
//-----------------------------------------------------------------------------

void szyfruj(char *naF,int e,int n)
{
   unsigned int m,r;
   struct stat sb;
   FILE *fIN,*fOUT;
   char M[81];
   div_t nF;
   int i,T;

   if( access(naF, F_OK | R_OK) )
   {
      perror(naF);
      exit(-12);
   }
   if( stat(naF, &sb) )
   {
      perror(naF);
      exit(-13);   
   }
   nF = div(sb.st_size, 2);
   fIN = fopen(naF,"r");
   if( fIN==NULL )
   {
      perror(naF);
      exit(-14);
   }
   strcat(strcpy(M,naF),".crp");
   fOUT = fopen(M,"w");
   if( fOUT==NULL )
   {
      perror(M);
      fclose(fIN);
      exit(-15);
   }
   fprintf(fOUT,"%u\n",(unsigned)sb.st_size);
   T = time(NULL);
   for(i=0; i<nF.quot; i=i+1)
   {
      m = 0;
      fread(&m,2,1,fIN);
      r = P(m,e,n);
      sprintf(M,"%08x",r);
      fwrite(M,8,1,fOUT);
   }
   if( nF.rem )
   {
      m = 0;
      fread(&m,1,1,fIN);
      m = P(m,e,n);
      sprintf(M,"%08x",m);
      fwrite(M,8,1,fOUT);
   }

   T = time(NULL)-T;
   fclose(fOUT);
   fclose(fIN);
   printf("Czas: %u sek.\n",T);
   if( 1<T )
      puts("Taki czas jest NIE DO PRZYJECIA !!!");
}
//-----------------------------------------------------------------------------

void deszyfruj(char *naFin,char *naFout,int d,int n)
{
   unsigned int m;
   FILE *fIN,*fOUT;
   div_t nF;
   char M[81];
   int i,T;

   fIN  = fopen(naFin,"r");
   fOUT = fopen(naFout,"w");
   if( fIN==NULL || fOUT==NULL )
   {
      puts("Upss.. blad otwarcia w deszyfruj()");
      exit(-17);
   }
   fgets(M,80,fIN);
   nF = div(atoi(M),2);
   T = time(NULL);
   for(i=0; i<nF.quot; i=i+1)
   {
      fread(M,8,1,fIN);
      *(M+8) = '\0';
      m = strtol(M,NULL,16);
      m = P(m,d,n);
      fwrite(&m,2,1,fOUT);
// pokazuje aktywnosc
      if( !((i+1)%10) )
      {
         fprintf(stdout,".");
         fflush(stdout);
      }
   }
   if( nF.rem )
   {
      fread(M,8,1,fIN);
      *(M+8) = '\0';
      m = strtol(M,NULL,16);
      m = P(m,d,n);
      fwrite(&m,1,1,fOUT);
   }
   puts("");
   T = time(NULL)-T;
   fclose(fOUT);
   fclose(fIN);
   printf("Czas: %u sek.\n",T);
   if( 1<T )
      puts("Taki czas jest NIE DO PRZYJECIA !!!");
}
//-----------------------------------------------------------------------------

void weryfikuj(char *naF1,char *naF2)
{
   struct stat sb1,sb2;
   FILE *fIN1,*fIN2;
   char buf1[129],buf2[129];
   div_t nF;
   int i;

   if( access(naF1,F_OK|R_OK)||access(naF2,F_OK|R_OK) )
   {
      puts("Upss... problem z dostepem do plikow !?");
      exit(-18);
   }
   if( stat(naF1, &sb1)||stat(naF2, &sb2) )
   {
      puts("Upss... cos nie tak z plikami !?");
      exit(-19);   
   }
   if( sb1.st_size!=sb2.st_size)
   {
      puts("Error: Zla wielkosc plikow !?");
      exit(-20);
   }
   nF = div(sb1.st_size, 2);
   if( (fIN1=fopen(naF1,"r"))==NULL || (fIN2=fopen(naF2,"r"))==NULL  )
   {
      puts("Upss... w weryfikuj() !?");
      exit(-21);
   }
   for(i=0; i<nF.quot; i=i+1)
   {
      fread(buf1,128,1,fIN1);
      fread(buf2,128,1,fIN2);
      if( memcmp(buf1,buf2,128)!=0 )
      {
         puts("Error: nie ma zgodnosci !?");
         exit(-22);
      }
   }
   if( nF.rem )
   {
      fread(buf1,nF.rem,1,fIN1);
      fread(buf2,nF.rem,1,fIN2);
      if( memcmp(buf1,buf2,nF.rem)!=0 )
      {
         puts("Error: nie ma zgodnosci !?");
         exit(-23);
      }
   }
   fclose(fIN1);
   fclose(fIN2);
}
//-----------------------------------------------------------------------------

