#include "libBaza.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>

int test(char *M)
{
   char *ws;
   int n;

   for(n=0,ws=strchr(M,';'); ws!=NULL; ws=strchr(++ws,';'))
      n++;
   return (n!=3);
}
//-----------------------------------------------------------------------------

int delSP(char *M,char *accept)
{
   int n;

   while( strchr(accept,*M)!=NULL )
      strcpy(M,M+1);
   n = strlen( M );
   while(0<n && strchr(accept,M[n-1])!=NULL)
      M[--n] = '\0';
   return n;
}
//-----------------------------------------------------------------------------

void inFromTXT(struct tTab **Tab, unsigned *nTab, char *naFtxt)
{
   char M[257],*wr,*ws,*wt;
   struct tTab TabR;
   FILE *fF;

   if( *Tab!=NULL )
      free( *Tab );
   *nTab = 0;
   if( (fF=fopen(naFtxt,"r"))==NULL )
   {
      perror(naFtxt);
      exit(-1);
   }
   while( fgets(M,256,fF)!=NULL )
   {
      if( test(M) )
      {
         printf("?:>%s<\n", M);
         continue;
      }
      memset(&TabR, '\0', sizeof(struct tTab));
// Imie
      wr  = strchr(M,';');
      *wr = '\0';
      if( !delSP(M," ") )
         continue;
      strcpy(TabR.Im,M);
// Nazwisko
      ws  = strchr(++wr,';');
      *ws = '\0';
      if( !delSP(wr," ") )
         continue;
      strcpy(TabR.Na,wr);
// NrIND
      wr  = strchr(++ws,';');
      *wr = '\0';
      if( !delSP(ws," ") )
         continue;
      TabR.NrIND = strtol(ws,&wt,10);
      if( *wt!='\0' || !delSP(++wr," \r\n\t") )
         continue;
// Ocena
      TabR.Ocena = strtol(wr,&wt,10);
      if( *wt!='\0' )
         continue;
// zapisanie do tablicy Tab
      *Tab = (struct tTab *)realloc(*Tab,(*nTab+1)*sizeof(struct tTab));
      memmove(*Tab+*nTab,&TabR,sizeof(struct tTab));
      ++*nTab;   
   }
   fclose(fF);
}
//-----------------------------------------------------------------------------

void wyswietl(struct tTab *Tab, unsigned nTab)
{
   unsigned i;

   if( nTab==0 )
   {
      puts(">> tablica jest pusta <<\n");
      return;
   }
   for(i=0; i<nTab; ++i)
   {
      printf("%2u: %-15s %-20s %06u %4i\n", i+1, (Tab+i)->Im, (Tab+i)->Na,\
                                            (Tab+i)->NrIND, (Tab+i)->Ocena);
   }
}
//-----------------------------------------------------------------------------

void outDAT(struct tTab *Tab, unsigned nTab, char *naFdat)
{
   unsigned i;
   FILE *fF;

   if( nTab==0 )
   {
      puts(">> tablica jest pusta <<\n");
      return;
   }
   if( (fF=fopen(naFdat,"w"))==NULL )
   {
      perror(naFdat);
      exit(-1);
   }
   for(i=0; i<nTab; ++i)
      fwrite(Tab+i, sizeof(struct tTab), 1, fF);   
   fclose( fF );
}
//-----------------------------------------------------------------------------

void inDAT(struct tTab **Tab, unsigned *nTab, char *naFdat)
{
   struct stat sb;
   unsigned i;
   FILE *fF;

   if( stat(naFdat, &sb) || (fF=fopen(naFdat,"r"))==NULL )
   {
      perror(naFdat);
      exit( -3 );
   }
   if( *Tab!=NULL )
      free( *Tab );
   *nTab = sb.st_size/sizeof(struct tTab);
   *Tab = (struct tTab *)malloc( sb.st_size );
   for(i=0; i<*nTab; ++i)
      fread(*Tab+i, sizeof(struct tTab), 1, fF);
   fclose( fF );
}
//-----------------------------------------------------------------------------

void edDAT(unsigned poz,struct tTab *Tab, unsigned nTab, char *naFdat)
{
   char M[81];

   if( poz<1 || nTab<poz)
   {
      puts("Upss...");
      return;
   }
   --poz;
   printf("Imie \"%s\": ",(Tab+poz)->Im);
   scanf("%s",M);
   strcpy((Tab+poz)->Im,M);
}
//-----------------------------------------------------------------------------
