#include <iostream>
#include <fstream>
#include <map>
#include <sstream>

using namespace std;

class TBio
{
    private:
        map<string, string> parModel;
        string naIn,naOut;

    public:
        TBio(const char *_naIn="input.txt",const char *_naOut="output.txt")
        {
            naIn  = _naIn;
            naOut = _naOut;
        }
        ~TBio()
        {
            cout << "\n>> Koniec <<" << endl;
        }

        void czytajDane()
        {
            string::size_type loc;
            ifstream inS;
            string s;

            inS.open(naIn.c_str(),ios::in);
            if( !inS )
            {
// tu powinno byc generowanie wyjatku
                cerr << "Error: \"" << naIn << "\"" << endl;
                return;
            }
            while( getline(inS,s) )
            {
                if( (loc=s.find( "=", 0))==string::npos )
                    break;
                parModel[s.substr(0,loc)] = s.substr(loc+1);
/* wyswietlam dla kontroli
                cout << s.substr(0,loc) << "=" << s.substr(loc+1) << endl;
*/
            }
            inS.close();
        }

        void allParam()
        {
            for( map<string, string>::iterator iter = parModel.begin(); iter != parModel.end(); ++iter )
            {
                cout << (*iter).first << "=" << (*iter).second << endl;
            }
        }

        void getParam(const char *par)
        {
            map<string,string>::iterator iter = parModel.find( par );
            if( iter == parModel.end() )
            {
// tu powinno byc generowanie wyjatku
                cerr << "Error: \"" << par << "\"" << endl;
                return;
            }
            cout << iter->first << "=" << iter->second << endl;
        }

        void zapiszParam()
        {
            ofstream outS;

            outS.open(naOut.c_str(),ios::out);
            if( !outS )
            {
// tu powinno byc generowanie wyjatku
                cerr << "Error: \"" << naOut << "\"" << endl;
                return;
            }
            outS << "Wszystkie:" << endl;
            for( map<string, string>::iterator iter = parModel.begin(); iter != parModel.end(); ++iter )
            {
                outS << (*iter).first << "=" << (*iter).second << endl;
            }
            outS << "\nWybrany parametr:" << endl;
            outS << "model=" << parModel["model"] << endl;
            outS << "\n\nmodel=" << parModel["steps"] << "\n\n\n\n" << endl;
            outS.close();
        }
        int getValPar(const char *par)
        {
            map<string,string>::iterator iter = parModel.find( par );
            istringstream ss;
            int v;

            if( iter == parModel.end() )
            {
// tu powinno byc generowanie wyjatku
                cerr << "Error: \"" << par << "\"" << endl;
                return -1;
            }
//            cout << iter->first << "=" << iter->second << endl;
            ss.str(iter->second);
            ss >> v;
            return v;
        }
};

int main()
{
    TBio *Bio;
    int var;

    Bio = new TBio("input.txt","_output.txt");
    Bio->czytajDane();
    Bio->allParam();
    Bio->getParam("abc");
    Bio->getParam("model");
    Bio->zapiszParam();
    cout << "\n(a)##\n";
    Bio->getParam("steps");
    cout << "#####\n" << endl;
    var = Bio->getValPar("steps");
    cout << "(b)----\nvar: " << var << "\n-------" << endl;
    delete Bio;
    return 0;
}
