#include <stdio.h>
#include <stdlib.h>
#include <string.h>

const char separator[] = ";\r\t\n";
const char sepStr[] = "\"";

struct TLst
{
    char Im[31],Na[31];
    double Ocena;
};

int parserCSV(char *buf, char *ws[], int n, const char *delim)
{
    int i;

    ws[0] = buf;
    for(i=1; i<=n; i=i+1)
    {
        ws[i] = strpbrk(ws[i-1], delim);
        if( ws[i]==NULL)
            break;
        *ws[i] = '\0';
        ws[i]  = ws[i]+1;
    }
    return i-1;
}

void readCSV(char *nazwaCSV,int *N, struct TLst Lst[])
{
    char buf[1024],*wr,*ws[32],*wt[3];
    FILE *fDane;
    int i,n;

    fDane = fopen(nazwaCSV, "r");
    *N = 0;
    n = 3;
    if( fDane==NULL )
    {
        perror(nazwaCSV);
        exit(-1);
    }
    printf("z pliku \"%s\" wczytano wiersze: \n\n", nazwaCSV);
//    puts("wczytano wiersze:\n");
    while( fgets(buf,1024,fDane)!=NULL )
    {
        printf(">%s<\n",buf);
        if( parserCSV(buf, ws, n, separator)!=n )
            continue;
        for(i=0; i<n; i=i+1)
        {
            if( parserCSV(ws[i], wt, 2, sepStr)==2 )
            {
                switch( i )
                {
                    case 0:
                        strcpy(Lst[*N].Im, wt[1]);
                     break;
                    case 1:
                        strcpy(Lst[*N].Na, wt[1]);
                     break;
                    default:
                        puts("ERROR: zly rekord !?");
                     break;
                }
            }
            else
            {
                wr = strchr(ws[i],',');
                if( wr!=NULL)
                    *wr = '.';
                Lst[*N].Ocena = atof(ws[i]);
            }
        }
        *N = *N+1;
    }
    fclose(fDane);
}

int main()
{
    struct TLst Lst[1000];
    double srednia;
    int i,N;

    readCSV("dane.csv", &N, Lst);
    puts("\notrzymano wykaz:\n");
    for(i=0; i<N; i=i+1)
    {
        printf("| %-20s| %-20s| %3.1lf |\n",Lst[i].Im, Lst[i].Na, Lst[i].Ocena);
    }
    puts("--------------------------------------");
// wyliczam np. srednia ocen:
    srednia = 0.0;
    for(i=0; i<N; i=i+1)
    {
        srednia = srednia+Lst[i].Ocena;
    }
    srednia = srednia/N;
    printf("srednia: %le\n", srednia);
    puts("--------------------------------------");
    return 0;
}
