// #include <sys/types.h>
#include <sys/stat.h>
// #include <unistd.h>

#include "MyLib.h"

/*!
 * \mainpage WIP
 *
 * \par Wykład Nr 11 w dniu 10 XII 09 r.
 *
 * Przewidywany plan wykładu:
 * - zasady szyfrowania RSA,
 * - tworzenie dokumentacji,
 * - własna biblioteka funkcji,
 * - będę się tłumaczył z wskaźników
 */

const int rsa_p = 61; /**< liczba pierwsza potrzebna w algorytmie RSA */
const int rsa_q = 53; /**< liczba pierwsza potrzebna w algorytmie RSA */

const char rsa_naFin[]  = "_MyLib.c"; /**< plika do zaszyfrowania */
const char rsa_naFcrp[] = "_MyLib.crp"; /**< zaszyfrowany plik */
const char rsa_naFres[] = "_MyLib.res"; /**< plik odszyfrowany */


/*!
 * sprawdzam, czy liczba \f$n\f$ jest pierwsza
 *
 * bardziej zaawansowane metody testowania:
 * <a href="http://pl.wikipedia.org/wiki/Test_pierwszo%C5%9Bci_AKS" target="_top">Test AKS</a> &nbsp;
 * (<a href="http://en.wikipedia.org/wiki/AKS_primality_test" target="_top">The AKS primality test</a>)
 */
int testPodziel( int n)
{
   int i,m;

   m = n/2;
   for(i=2; i<m && n%i ; i=i+1)
      ;
   return (int)(i<m);
}

/*!
 * generowanie klucza publicznego i prywatnego
 * na rzecz metody szyfrowania RSA
 */
int genKluczeRSA(int *e, int *d, int p, int q)
{
    int n,fi_n,y;

    if(testPodziel(p) || testPodziel(q))
    {
       puts("Upss ...");
       exit(-1);
    }
    n = p*q;
    fi_n = (p-1)*(q-1);
/*!
 * \note
 * liczba \f$e\f$ jest wybrana w ten sposob, aby  byla
 * wzglednie pierwsza z \f$\varphi(n) \f$ tu \f$\varphi(n)=(p-1)(q-1)\f$
 */
    *e = 17;
    if( NWD(*e,fi_n)!=1 )
    {
       puts("Upss ...");
       exit(-1);
    }
/*!
 * \note
 *  obliczam \f$d\f$ spelniajace \f$ed = 1 \mathop{\mathrm{mod}} \varphi(n)\f$
 */
    NWDr(*e,fi_n,d,&y);
    while( *d<0 )
    {
       *d = (*d+fi_n) % fi_n;
    }
    return n;
}

/*!
 * wyznaczenie wielkosci pliku w bajtach
 *
 * \param naF nazwa pliku
 */
int sizeF(const char *naF)
{
   struct stat sb;

   if( stat(naF, &sb)==-1 )
   {
      perror(naF);
      exit(-1);
   }
   return (int)sb.st_size;
}

/*!
 * szyfrowanie metoda RSA pliku
 *
 * \f$e, n\f$ klucz publiczny
 */
void kryptFile(const char *naFout, const char *naFin, int e, int n)
{
   FILE *Fout,*Fin;
   int i,N,M0,P;
#if RSA_HEX
   char str[10],c;
#else
   char c;
#endif

   N = sizeF(naFin);
   Fin = fopen(naFin, "r");
   if( Fin==NULL )
   {
      perror(naFin);
      exit(-1);
   }
   Fout = fopen(naFout, "w");
   for(i=0; i<N; i=i+1)
   {
      fread(&c,1,1,Fin);
      M0 = (int)c;
      P  = pmod(M0,e,n);
#if RSA_HEX
      sprintf(str,"%08x",P);
      fwrite(str,8,1,Fout);
#else
      fwrite(&P,sizeof(int),1,Fout);
#endif
   }
   fclose(Fout);
   fclose(Fin);
}

/*!
 * deszyfracja pliku zaszyfrowanego metoda RSA
 *
 * \f$d, n\f$ klucz prywatny
 */
void deKryptFile(const char *naFout, const char *naFin, int d, int n)
{
   FILE *Fout,*Fin;
   int i,N,M1,P;
   char str[10];

#if RSA_HEX
   N = sizeF(naFin)/8;
#else
   N = sizeF(naFin)/sizeof(int);
#endif
   Fin = fopen(naFin, "r");
   if( Fin==NULL )
   {
      perror(naFin);
      exit(-1);
   }
   Fout = fopen(naFout, "w");
   for(i=0; i<N; i=i+1)
   {
#if RSA_HEX
      fread(str,8,1,Fin);
      str[8] = '\0';
      P  = strtol(str,NULL,16);
#else
      fread(&P,sizeof(int),1,Fin);
#endif
      M1 = pmod(P,d,n);
      sprintf(str,"%c", (char)M1);
      fwrite(str,1,1,Fout);
   }
   fclose(Fout);
   fclose(Fin);
}

/*!
 * sprawdzenie identycznosci plikow
 */
int sprRSA(const char *naF1, const char *naF2)
{
   FILE *F1,*F2;
   unsigned char c1,c2;
   int i,n;

   n = sizeF(naF1);
   if( n!=sizeF(naF2) )
   {
      return -1;
   }
   F1 = fopen(naF1,"r");
   F2 = fopen(naF2,"r");
   for(i=0; i<n; i=i+1)
   {
      fread(&c1,1,1,F1);
      fread(&c2,1,1,F2);
      if( c1!=c2)
         break;
   }
   fclose(F2);
   fclose(F1);
   return (i!=n ? -2 : 0 );
}

int main()
{
   int n,e,d,M0,M1,P;

   n = genKluczeRSA(&e, &d, rsa_p, rsa_q);
   printf("Klucz publiczny: (%i, %i)\n", e,n);
   printf("Klucz prywatny : (%i, %i)\n\n", d,n);
// kodowanie liczby M
   M0 = 123;
   P  = pmod(M0,e,n);
   printf("liczbe: %i zakodowano jako: %i\n", M0, P);
// dekodowanie P
   M1 = pmod(P,d,n);
// sprawdzenie
   printf("sprawdzenie kodowania liczby: ");
   if( M0!=M1 )
   {
      puts("Upss ...\n");
      exit(-1);
   }
   else
   {
      puts("OK !\n");
   }
   puts("Szyfrowanie plikow\n");
   printf("Plik do zaszyfrowania: \t%s\n",rsa_naFin);
   printf("Plik zaszyfrowany:\t%s\n",rsa_naFcrp);
   printf("Plik odszyfrowany:\t%s\n\n",rsa_naFres);
#if RSA_HEX
   puts("Plik zaszyfrowany bedzie w hexach");
#else
   puts("Plik zaszyfrowany bedzie w postaci binarnej");
#endif
   kryptFile( rsa_naFcrp, rsa_naFin, e, n);
   deKryptFile( rsa_naFres, rsa_naFcrp, d, n);
   if( sprRSA(rsa_naFin, rsa_naFres) < 0 )
   {
      puts("Szyfrowanie i deszyfrowanie plikow NIE jest prawidlowe");
   }
   else
   {
      puts("Szyfrowanie i deszyfrowanie plikow JEST poprawne");
   }
   return 0;
}
