#include "MyLib.h"

// Wyklad Nr 06

/*!
 * maksymalna ilosc wierszy w macierzy
 */
const int matrix_N=25;
/*!
 * maksymalna ilosc kolumn w macierzy
 */
const int matrix_M=25;

void WyswietlMacierz(int n, int m, double a[][matrix_M])
{
    int i,j;

    for(i=0; i<n; i=i+1)
    {
        for(j=0; j<m; j=j+1)
        {
            printf("%6.2lf ",a[i][j]);
        }
        printf("\n");
    }
}

void ZapisMacierzy(char *NazwaPliku, int n, int m, double a[][matrix_M])
{
    FILE *fPlik;
    int i,j;

    fPlik = fopen(NazwaPliku,"w");
    fprintf(fPlik,"%i\n%i\n",n,m);
    for(i=0; i<n; i=i+1)
    {
        for(j=0; j<m; j=j+1)
        {
            fprintf(fPlik,"%4.2lf\n",a[i][j]);
        }
    }
    fclose(fPlik);
}

void OdczytMacierzy(char *NazwaPliku, int *n, int *m, double a[][matrix_M])
{
    FILE *fPlik;
    int i,j;

    fPlik = fopen(NazwaPliku,"r");
    fscanf(fPlik,"%i", n);
    fscanf(fPlik,"%i", m);
    for(i=0; i<*n; i=i+1)
    {
        for(j=0; j<*m; j=j+1)
        {
            fscanf(fPlik,"%lf",&a[i][j]);
        }
    }
    fclose(fPlik);
}
//-------------------------------------------------------------------------
// Wyklad Nr 08

const char separator[] = ";\r\t\n";
const char sepStr[] = "\"";

/*!
 * Obsluguje formaty <a href="http://pl.wikipedia.org/wiki/CSV_(format_pliku)" target="_top">Excel-CSV</a>
 * oraz <a href="http://pl.wikipedia.org/wiki/CSV_(format_pliku)" target="_top">TSV (ISO-8859-2)</a>
 */

int parserCSV(char *buf, char *ws[], int n, const char *delim)
{
    int i;

    ws[0] = buf;
    for(i=1; i<=n; i=i+1)
    {
        ws[i] = strpbrk(ws[i-1], delim);
        if( ws[i]==NULL)
            break;
        *ws[i] = '\0';
        ws[i]  = ws[i]+1;
    }
    return i-1;
}

void readCSV(char *nazwaCSV,int *N, struct TLst Lst[])
{
    char buf[1024],*wr,*ws[32],*wt[3];
    FILE *fDane;
    int i,n;

    fDane = fopen(nazwaCSV, "r");
    *N = 0;
    n = 3;
    if( fDane==NULL )
    {
        perror(nazwaCSV);
        exit(-1);
    }
    printf("z pliku \"%s\"", nazwaCSV);
    while( fgets(buf,1024,fDane)!=NULL )
    {
/* tu mozemy sprawdzic co jest wczytywane
        printf(">%s<\n",buf);
*/
        if( parserCSV(buf, ws, n, separator)!=n )
            continue;
        for(i=0; i<n; i=i+1)
        {
            if( parserCSV(ws[i], wt, 2, sepStr)==2 )
            {
                switch( i )
                {
                    case 0:
                        strcpy(Lst[*N].Im, wt[1]);
                     break;
                    case 1:
                        strcpy(Lst[*N].Na, wt[1]);
                     break;
                    default:
                        puts("ERROR: zly rekord !?");
                     break;
                }
            }
            else
            {
                wr = strchr(ws[i],',');
                if( wr!=NULL)
                    *wr = '.';
                Lst[*N].Ocena = atof(ws[i]);
            }
        }
        *N = *N+1;
    }
    fclose(fDane);
}
//-------------------------------------------------------------------------
// Wyklad Nr 11

/*!
 * Najwiekszy Wspolny Dzielnik
 *
 * Popularny algorytm Euklidesa
 */
int NWD(int p, int q)
{
   int r;

   if( p<1 || q<1 )
   {
      puts("Ups ...");
      exit(-1);
   }
   for(r=p%q; r!=0; r=p%q)
   {
      p = q;
      q = r;
   }
   return q;
}

/*!
 * rozszerzony algorytm Euklidesa: \f$p*x+q*y=\mathop{\mathrm{NWD}}(p,q)\f$
 */
int NWDr(int p, int q, int *x, int *y)
{
   int r,t,xp,xr,yp,yr;

   if( p<1 || q<1 )
   {
      puts("Ups ...");
      exit(-1);
   }
   xp = *y = 1;
   *x = yp = 0;
   for(r=p%q; r!=0; r=p%q)
   {
      t  = p/q;
      p  = q;
      q  = r;
      xr = *x;
      *x = xp - t*xr;
      xp = xr;
      yr = *y;
      *y = yp - t*yr;
      yp = yr;
   }
   return q;
}

/*!
 * naiwna potega \f$b^e \mathop{\mathrm{mod}} m\f$
 */
int pmod(int b, int e, int m)
{
   int c;

   for(c=1; 1<=e; e=e-1)
   {
      c = (c*b)%m;
   }
   return c;
}
//-------------------------------------------------------------------------
