#include "MyLib.h"

/*!
 * \mainpage Wyznacznik macierzy
 *
 * \par Wykład Nr 12 w dniu 17 XII 09 r.
 *
 * Przewidywany plan wykładu:
 * - obliczenie wyznacznika macierzy metoda eleminacji Gaussa (<a href="http://en.wikipedia.org/wiki/Gaussian_elimination" target="_top">Gaussian elimination</a>),
 * - rozwiazywanie ukladow rownan,
 * - Parametry komputerowych liczb rzeczywistych: <a href="http://www.gnu.org/s/libc/manual/html_node/Floating-Point-Parameters.html" target="_top">Floating Point Parameters</a> &nbsp;
 *   oraz to samo w wydaniu kalkulatorowym: <a href="http://tigcc.ticalc.org/doc/float.html" target="_top">The <float.h> Header File</a>
 * - zlozonosc obliczeniowa.
 */

const char det_naF[] = "A.dat"; /**< nazwa pliku z macierza */

/*!
 * wyswietlenie macierzy z uwzglednieniem permutacji wierszy
 * \param P permutacja wierszy
 */
void WyswietlMacierzInd(int n, int m, double A[][matrix_M],int P[])
{
    int i,j;

    for(i=0; i<n; i=i+1)
    {
        for(j=0; j<m; j=j+1)
        {
            printf("%6.2lf ",A[P[i]][j]);
        }
        printf("\n");
    }
}

void WyswietlWiersz(int m, double w[])
{
    int j;

    for(j=0; j<m; j=j+1)
    {
        printf("%6.2lf ",w[j]);
    }
    printf("\n");
}

/*!
 * obliczenie wyznacznika metoda eleminacji Gaussa (<a href="http://en.wikipedia.org/wiki/Gaussian_elimination" target="_top">Gaussian elimination</a>),
 * \param P opisuje zamiane wierszy,
 * \param row okresla wiersz do ktorego metoda &quot;doszla&quot;.
 */
double ObliczWyznacznik(int *row, int P[], int n, int m, double A[][matrix_M])
{
   double d[matrix_M],det;
   int i,j;

   for(i=0; i<matrix_N; i=i+1)
   {
      P[i] = i;
   }
   det = 1.0;
   for(*row=0; *row<n; *row=*row+1)
   {
      if( fabs(A[P[*row]][*row])<=1.0e-100 )
      {
         for(i=*row+1; i<n; i=i+1 )
         {
            if( 1.0e-100<fabs( A[P[i]][*row] ) )
            {
               j       = P[*row];
               P[*row] = P[i];
               P[i]    = j;
               det     = -det;
               break;
            }
         }
         if( i==n )
         {
            for(i=0; i<*row-1; i=i+1)
            {
               det = A[P[i]][i]*det;
            }
            return det;
         }
      }
      for(i=*row+1; i<m; i=i+1)
      {
         d[i] = A[P[*row]][i]/A[P[*row]][*row];
      }
      for(j=*row+1; j<n; j=j+1)
      {
         for(i=*row+1; i<m; i=i+1)
         {
            A[P[j]][i] = A[P[j]][i]-d[i]*A[P[j]][*row];
         }
         A[P[j]][*row] = 0.0;
      }
   }
   for(i=0; i<n; i=i+1)
   {
      det = A[P[i]][i]*det;
   }
   return det;
}

int main()
{
   double det,A[matrix_N][matrix_M];
   int n,m,P[matrix_N],row;

   OdczytMacierzy(det_naF, &n, &m, A);
   printf("wczytana macierz: \"%s\"\n", det_naF);
   WyswietlMacierz(n, m, A);
   det = ObliczWyznacznik(&row, P, n, m, A);
   if( row!=n )
   {
      printf("Macierz \"%s\" jest osobliwa\n", det_naF);
      exit(-1);
   }
   puts("-----------------------------");
   printf("wyznacznik: %16le\n", det);
   puts("-----------------------------");
   puts("Wynikowa macierz gornotrojkatna:");
   WyswietlMacierzInd(n, m, A, P);
   puts("\nBez uwzglednienia przestawien wierszy:");
   WyswietlMacierz(n, m, A);
   puts("\nPermutacja wierszy:");
   for(row=0; row<n; row=row+1)
   {
      printf("%2i ",row+1);
   }
   puts("");
   for(row=0; row<n; row=row+1)
   {
      printf("%2i ",P[row]+1);
   }
   puts("");
   return 0;
}
