#include "MyLib.h"
/* w przypadku np. pracy w srodowisku Windows
#ifdef _WIN32

#endif
*/

// #define _WIN32

#ifndef _WIN32
extern int strptime(const char *s, const char *format, struct tm *tm);
#endif


/*!
 * \mainpage Sortowanie
 *
 * \par Wykład Nr 13 w dniu 7 I 10 r.
 *
 * Przewidywany plan wykładu:
 * - różne metody sortowania,
 * - funkcja jako parametr,
 * - uzycie funkcji biblioteczne: <a href="http://www.cppreference.com/wiki/c/other/qsort" target="_top"> qsort </a>,
 * - zlozonosc obliczeniowa sortowania,
 * - odnośniki do wiki: <a href="http://en.wikipedia.org/wiki/Sorting_algorithm" target="_top"> sorting algorithm </a>,
 *    &nbsp; <a href="http://pl.wikipedia.org/wiki/Sortowanie" target="_top"> sortowanie </a>
 * - ciekawa strona o programowaniu w C: <a href="http://en.wikibooks.org/wiki/C_Programming" target="_top"> C Programming </a>
 */
#ifdef _WIN32
int strptime(char *strDat, const char *format, struct tm *tm)
{
   char *wr,*ws,*wt,_strDat[15];

   strncpy(_strDat,strDat,12);
   _strDat[12] = '\0';
   wr = strchr(_strDat,'-');
   if( wr==NULL )
   {
      return 0;
   }
   *wr = '\0';
   tm->tm_year = strtol(_strDat,&wt,10)-1900;
   wr = wr+1;
   ws = strchr(wr,'-');
   if( ws==NULL || *wt!='\0' || tm->tm_year<70 || tm->tm_year>137 )
   {
      return 0;
   }
   *ws = '\0';
   tm->tm_mon = strtol(wr,&wt,10)-1;
   if( *wt!='\0' || tm->tm_mon<0 || tm->tm_mon>11 )
   {
      return 0;
   }
   ws = ws+1;
   tm->tm_mday = strtol(ws,&wt,10);
   if( *wt!='\0' || tm->tm_mday<0 || tm->tm_mday>31 )
   {
      return 0;
   }
   return (int)(wt-_strDat);
}
#endif

time_t strToTime(char *strDat)
{
   struct tm tm;
   time_t T;
   char *ws;

   memset(&tm,'\0',sizeof(struct tm));
   ws = strpbrk(strDat,"\r\n\t");
   if( ws!=NULL )
   {
      *ws = '\0';
   }
   if( !strptime( strDat, "%Y-%m-%d", &tm) )
   {
      printf("Bledna data: \"%s\" !?\n", strDat);
      return 0;
   }
   T = mktime( &tm);
   return T;
}

void readCSV(char *nazwaCSV,int *N, struct TLst Lst[])
{
   char buf[1024],*wr,*ws[32],*wt[3];
   FILE *fDane;
   int i,n,OK;

   fDane = fopen(nazwaCSV, "r");
   *N = 0;
   n  = 30;
   if( fDane==NULL )
   {
      perror(nazwaCSV);
      exit(-1);
   }
   printf("z pliku \"%s\"\n", nazwaCSV);
   while( fgets(buf,1024,fDane)!=NULL )
   {
      n  = 3;
      OK = 1;
      if( parserCSV(buf, ws, n, separator)!=n )
         continue;
      for(i=0; i<4 && OK ; i=i+1)
      {
         if( parserCSV(ws[i], wt, 2, sepStr)==2 )
         {
            switch( i )
            {
               case 0:
                  strcpy(Lst[*N].Im, wt[1]);
                break;
               case 1:
                  strcpy(Lst[*N].Na, wt[1]);
                break;
               default:
                  puts("ERROR: zly rekord !?");
                  OK = 0;
                break;
            }
         }
         else
         {
            switch( i )
            {
               case 2:
                  wr = strchr(ws[i],',');
                  if( wr!=NULL)
                     *wr = '.';
                  Lst[*N].Ocena = strtod(ws[i],&wr);
                  if( *wr!='\0' )
                  {
                     OK = 0;
                  }
                break;
               case 3:
                  Lst[*N].Data = strToTime(ws[i]);
                  if( Lst[*N].Data==0 )
                  {
                     OK = 0;
                  }
                break;
               default:
                  puts("ERROR: zly rekord !?");
                  OK = 0;
                break;
            }
         }
      }
      if( OK )
      {
         *N = *N+1;
      }
   }
   fclose(fDane);
}

void sortProc1(int N, struct TLst *Lst)
{
   struct TLst LstR;
   int i,j;

   for(i=0; i<N; i=i+1)
   {
      for(j=i+1; j<N; j=j+1)
      {
//         if( 0<strcmp((Lst+i)->Na,(Lst+j)->Na) )
         if( (Lst+i)->Data > (Lst+j)->Data )
         {
            memmove(&LstR,Lst+j,sizeof(struct TLst));
            memmove(Lst+j,Lst+i,sizeof(struct TLst));
            memmove(Lst+i,&LstR,sizeof(struct TLst));
         }
      }
   }
}

int cmpIm(const void *m1, const void *m2)
{
   struct TLst *Lst1;
   struct TLst *Lst2;

   Lst1 = (struct TLst *)m1;
   Lst2 = (struct TLst *)m2;
   return strcmp(Lst1->Im, Lst2->Im);
}

int cmpNa(const void *m1, const void *m2)
{
   struct TLst *Lst1;
   struct TLst *Lst2;

   Lst1 = (struct TLst *)m1;
   Lst2 = (struct TLst *)m2;
   return strcmp(Lst1->Na, Lst2->Na);
}

void sortProc2(void *base, size_t nmemb, size_t size, int(*compar)(const void *, const void *))
{
   char *buf,*ws1,*ws2,m[1024];
   int i,j;

   buf = (char *)base;
   for(i=0; i<nmemb; i=i+1)
   {
      for(j=i+1; j<nmemb; j=j+1)
      {
         ws1 = buf+i*size;
         ws2 = buf+j*size;
         if( 0<(*compar)(ws1, ws2) )
         {
            memmove(m, ws2, size);
            memmove(ws2, ws1, size);
            memmove(ws1, m, size);
         }
      }
   }
}

void wyswietlLst(int N, struct TLst *Lst)
{
   char strDat[81];
   struct tm tm;
   time_t T;
   int i;

   for(i=0; i<N; i=i+1)
   {
      printf("%s\t\t%s\t\t%10.3lf\t", (Lst+i)->Im, (Lst+i)->Na, (Lst+i)->Ocena);
      T = (Lst+i)->Data;
      memmove(&tm, localtime( &T ), sizeof(struct tm));
      strftime(strDat, 31, "%Y-%m-%d", &tm);
      printf("%s\n", strDat);
   }
}

int main()
{
   struct TLst Lst[100];
   int N;

   readCSV("dane.csv", &N, Lst);
   puts("####################");
   printf("N: %i\n", N);
   puts("== SORTOWANIE =========================");
   puts(" imie      nazwisko                 ocena           data\n");
   puts("- surowe ------------------------------");
   wyswietlLst(N, Lst);
   puts("- po dacie ----------------------------");
   sortProc1(N, Lst);
   wyswietlLst(N, Lst);
   puts("- po imieniu --------------------------");
   sortProc2(Lst, N, sizeof(struct TLst), cmpIm);
   wyswietlLst(N, Lst);
   puts("- po nazwisku -------------------------");
   qsort(Lst, N, sizeof(struct TLst), cmpNa);
   wyswietlLst(N, Lst);
   puts("---------------------------------------");
#ifdef _WIN32
   system("PAUSE");
#endif
   return 0;
}
