#include "MyLib.h"

// Wyklad Nr 06

const int matrix_N=25; /**< maksymalna ilosc wierszy w macierzy */
const int matrix_M=25; /**< maksymalna ilosc kolumn w macierzy */

void WyswietlMacierz(int n, int m, double a[][matrix_M])
{
    int i,j;

    for(i=0; i<n; i=i+1)
    {
        for(j=0; j<m; j=j+1)
        {
            printf("%6.2lf ",a[i][j]);
        }
        printf("\n");
    }
}

void ZapisMacierzy(char *NazwaPliku, int n, int m, double a[][matrix_M])
{
    FILE *fPlik;
    int i,j;

    fPlik = fopen(NazwaPliku,"w");
    fprintf(fPlik,"%i\n%i\n",n,m);
    for(i=0; i<n; i=i+1)
    {
        for(j=0; j<m; j=j+1)
        {
            fprintf(fPlik,"%4.2lf\n",a[i][j]);
        }
    }
    fclose(fPlik);
}

void OdczytMacierzy(const char *NazwaPliku, int *n, int *m, double a[][matrix_M])
{
    FILE *fPlik;
    int i,j;

    fPlik = fopen(NazwaPliku,"r");
    fscanf(fPlik,"%i", n);
    fscanf(fPlik,"%i", m);
    for(i=0; i<*n; i=i+1)
    {
        for(j=0; j<*m; j=j+1)
        {
            fscanf(fPlik,"%lf",&a[i][j]);
        }
    }
    fclose(fPlik);
}
//-------------------------------------------------------------------------
// Wyklad Nr 08

const char separator[] = ";\r\t\n";
const char sepStr[] = "\"";

/*!
 * Obsluguje formaty <a href="http://pl.wikipedia.org/wiki/CSV_(format_pliku)" target="_top">Excel-CSV</a>
 * oraz <a href="http://pl.wikipedia.org/wiki/CSV_(format_pliku)" target="_top">TSV (ISO-8859-2)</a>
 */

int parserCSV(char *buf, char *ws[], int n, const char *delim)
{
    int i;

    ws[0] = buf;
    for(i=1; i<=n; i=i+1)
    {
        ws[i] = strpbrk(ws[i-1], delim);
        if( ws[i]==NULL)
            break;
        *ws[i] = '\0';
        ws[i]  = ws[i]+1;
    }
    return i-1;
}

/* stara funkcja wczytania rekordow z pliku
void readCSV(char *nazwaCSV,int *N, struct TLst Lst[])
{
    char buf[1024],*wr,*ws[32],*wt[3];
    FILE *fDane;
    int i,n;

    fDane = fopen(nazwaCSV, "r");
    *N = 0;
    n = 3;
    if( fDane==NULL )
    {
        perror(nazwaCSV);
        exit(-1);
    }
    printf("z pliku \"%s\"", nazwaCSV);
    while( fgets(buf,1024,fDane)!=NULL )
    {
// tu mozemy sprawdzic co jest wczytywane
//        printf(">%s<\n",buf);

        if( parserCSV(buf, ws, n, separator)!=n )
            continue;
        for(i=0; i<n; i=i+1)
        {
            if( parserCSV(ws[i], wt, 2, sepStr)==2 )
            {
                switch( i )
                {
                    case 0:
                        strcpy(Lst[*N].Im, wt[1]);
                     break;
                    case 1:
                        strcpy(Lst[*N].Na, wt[1]);
                     break;
                    default:
                        puts("ERROR: zly rekord !?");
                     break;
                }
            }
            else
            {
                wr = strchr(ws[i],',');
                if( wr!=NULL)
                    *wr = '.';
                Lst[*N].Ocena = atof(ws[i]);
            }
        }
        *N = *N+1;
    }
    fclose(fDane);
}
*/
//-------------------------------------------------------------------------
// Wyklad Nr 11

const int rsa_p = 61; /**< liczba pierwsza potrzebna w algorytmie RSA */
const int rsa_q = 53; /**< liczba pierwsza potrzebna w algorytmie RSA */

const char rsa_naFin[]  = "_MyLib.c"; /**< plika do zaszyfrowania */
const char rsa_naFcrp[] = "_MyLib.crp"; /**< zaszyfrowany plik */
const char rsa_naFres[] = "_MyLib.res"; /**< plik odszyfrowany */

/*!
 * Najwiekszy Wspolny Dzielnik
 *
 * Popularny algorytm Euklidesa
 */
int NWD(int p, int q)
{
   int r;

   if( p<1 || q<1 )
   {
      puts("Ups ...");
      exit(-1);
   }
   for(r=p%q; r!=0; r=p%q)
   {
      p = q;
      q = r;
   }
   return q;
}

/*!
 * rozszerzony algorytm Euklidesa: \f$p*x+q*y=\mathop{\mathrm{NWD}}(p,q)\f$
 */
int NWDr(int p, int q, int *x, int *y)
{
   int r,t,xp,xr,yp,yr;

   if( p<1 || q<1 )
   {
      puts("Ups ...");
      exit(-1);
   }
   xp = *y = 1;
   *x = yp = 0;
   for(r=p%q; r!=0; r=p%q)
   {
      t  = p/q;
      p  = q;
      q  = r;
      xr = *x;
      *x = xp - t*xr;
      xp = xr;
      yr = *y;
      *y = yp - t*yr;
      yp = yr;
   }
   return q;
}

/*!
 * naiwna potega \f$b^e \mathop{\mathrm{mod}} m\f$
 */
int pmod(int b, int e, int m)
{
   int c;

   for(c=1; 1<=e; e=e-1)
   {
      c = (c*b)%m;
   }
   return c;
}

/*!
 * sprawdzam, czy liczba \f$n\f$ jest pierwsza
 *
 * bardziej zaawansowane metody testowania:
 * <a href="http://pl.wikipedia.org/wiki/Test_pierwszo%C5%9Bci_AKS" target="_top">Test AKS</a> &nbsp;
 * (<a href="http://en.wikipedia.org/wiki/AKS_primality_test" target="_top">The AKS primality test</a>)
 */
int testPodziel( int n)
{
   int i,m;

   m = n/2;
   for(i=2; i<m && n%i ; i=i+1)
      ;
   return (int)(i<m);
}

/*!
 * generowanie klucza publicznego i prywatnego
 * na rzecz metody szyfrowania RSA
 */
int genKluczeRSA(int *e, int *d, int p, int q)
{
    int n,fi_n,y;

    if(testPodziel(p) || testPodziel(q))
    {
       puts("Upss ...");
       exit(-1);
    }
    n = p*q;
    fi_n = (p-1)*(q-1);
/*!
 * \note
 * liczba \f$e\f$ jest wybrana w ten sposob, aby  byla
 * wzglednie pierwsza z \f$\varphi(n) \f$ tu \f$\varphi(n)=(p-1)(q-1)\f$
 */
    *e = 17;
    if( NWD(*e,fi_n)!=1 )
    {
       puts("Upss ...");
       exit(-1);
    }
/*!
 * \note
 *  obliczam \f$d\f$ spelniajace \f$ed = 1 \mathop{\mathrm{mod}} \varphi(n)\f$
 */
    NWDr(*e,fi_n,d,&y);
    while( *d<0 )
    {
       *d = (*d+fi_n) % fi_n;
    }
    return n;
}

/*!
 * wyznaczenie wielkosci pliku w bajtach
 *
 * \param naF nazwa pliku
 */
int sizeF(const char *naF)
{
   struct stat sb;

   if( stat(naF, &sb)==-1 )
   {
      perror(naF);
      exit(-1);
   }
   return (int)sb.st_size;
}

/*!
 * szyfrowanie metoda RSA pliku
 *
 * \f$e, n\f$ klucz publiczny
 */
void kryptFile(const char *naFout, const char *naFin, int e, int n)
{
   FILE *Fout,*Fin;
   int i,N,M0,P;
#if RSA_HEX
   char str[10],c;
#else
   char c;
#endif

   N = sizeF(naFin);
   Fin = fopen(naFin, "r");
   if( Fin==NULL )
   {
      perror(naFin);
      exit(-1);
   }
   Fout = fopen(naFout, "w");
   for(i=0; i<N; i=i+1)
   {
      fread(&c,1,1,Fin);
      M0 = (int)c;
      P  = pmod(M0,e,n);
#if RSA_HEX
      sprintf(str,"%08x",P);
      fwrite(str,8,1,Fout);
#else
      fwrite(&P,sizeof(int),1,Fout);
#endif
   }
   fclose(Fout);
   fclose(Fin);
}

/*!
 * deszyfracja pliku zaszyfrowanego metoda RSA
 *
 * \f$d, n\f$ klucz prywatny
 */
void deKryptFile(const char *naFout, const char *naFin, int d, int n)
{
   FILE *Fout,*Fin;
   int i,N,M1,P;
   char str[10];

#if RSA_HEX
   N = sizeF(naFin)/8;
#else
   N = sizeF(naFin)/sizeof(int);
#endif
   Fin = fopen(naFin, "r");
   if( Fin==NULL )
   {
      perror(naFin);
      exit(-1);
   }
   Fout = fopen(naFout, "w");
   for(i=0; i<N; i=i+1)
   {
#if RSA_HEX
      fread(str,8,1,Fin);
      str[8] = '\0';
      P  = strtol(str,NULL,16);
#else
      fread(&P,sizeof(int),1,Fin);
#endif
      M1 = pmod(P,d,n);
      sprintf(str,"%c", (char)M1);
      fwrite(str,1,1,Fout);
   }
   fclose(Fout);
   fclose(Fin);
}

/*!
 * sprawdzenie identycznosci plikow
 */
int sprRSA(const char *naF1, const char *naF2)
{
   FILE *F1,*F2;
   unsigned char c1,c2;
   int i,n;

   n = sizeF(naF1);
   if( n!=sizeF(naF2) )
   {
      return -1;
   }
   F1 = fopen(naF1,"r");
   F2 = fopen(naF2,"r");
   for(i=0; i<n; i=i+1)
   {
      fread(&c1,1,1,F1);
      fread(&c2,1,1,F2);
      if( c1!=c2)
         break;
   }
   fclose(F2);
   fclose(F1);
   return (i!=n ? -2 : 0 );
}
//-------------------------------------------------------------------------
// Wyklad Nr 12

const char det_naF[] = "A.dat"; /**< nazwa pliku z macierza */

/*!
 * wyswietlenie macierzy z uwzglednieniem permutacji wierszy
 * \param P permutacja wierszy
 */
void WyswietlMacierzInd(int n, int m, double A[][matrix_M],int P[])
{
    int i,j;

    for(i=0; i<n; i=i+1)
    {
        for(j=0; j<m; j=j+1)
        {
            printf("%6.2lf ",A[P[i]][j]);
        }
        printf("\n");
    }
}

void WyswietlWiersz(int m, double w[])
{
    int j;

    for(j=0; j<m; j=j+1)
    {
        printf("%6.2lf ",w[j]);
    }
    printf("\n");
}

/*!
 * obliczenie wyznacznika metoda eleminacji Gaussa (<a href="http://en.wikipedia.org/wiki/Gaussian_elimination" target="_top">Gaussian elimination</a>),
 * \param P opisuje zamiane wierszy,
 * \param row okresla wiersz do ktorego metoda &quot;doszla&quot;.
 */
double ObliczWyznacznik(int *row, int P[], int n, int m, double A[][matrix_M])
{
   double d[matrix_M],det;
   int i,j;

   for(i=0; i<matrix_N; i=i+1)
   {
      P[i] = i;
   }
   det = 1.0;
   for(*row=0; *row<n; *row=*row+1)
   {
      if( fabs(A[P[*row]][*row])<=1.0e-100 )
      {
         for(i=*row+1; i<n; i=i+1 )
         {
            if( 1.0e-100<fabs( A[P[i]][*row] ) )
            {
               j       = P[*row];
               P[*row] = P[i];
               P[i]    = j;
               det     = -det;
               break;
            }
         }
         if( i==n )
         {
            for(i=0; i<*row-1; i=i+1)
            {
               det = A[P[i]][i]*det;
            }
            return det;
         }
      }
      for(i=*row+1; i<m; i=i+1)
      {
         d[i] = A[P[*row]][i]/A[P[*row]][*row];
      }
      for(j=*row+1; j<n; j=j+1)
      {
         for(i=*row+1; i<m; i=i+1)
         {
            A[P[j]][i] = A[P[j]][i]-d[i]*A[P[j]][*row];
         }
         A[P[j]][*row] = 0.0;
      }
   }
   for(i=0; i<n; i=i+1)
   {
      det = A[P[i]][i]*det;
   }
   return det;
}
//-------------------------------------------------------------------------
// Wyklad Nr 13

//-------------------------------------------------------------------------
