/* Komentarz K.T. 13 I 11 r.
 * Rozne sposoby sortowania oraz pokazanie
 * jak uzywac bibliotecznej funkcji qsort
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int c[]={2,1,3,-1,5, 10, -10, -2};

struct TRec
{
   int NrInd;
   char Nazwisko[30];
};

int cmpInd( const void *a, const void *b )
{
   struct TRec *Rec1,*Rec2;

   Rec1 = (struct TRec *)a;
   Rec2 = (struct TRec *)b;
   return Rec1->NrInd - Rec2->NrInd;
}

int cmpNa( const void *a, const void *b )
{
   struct TRec *Rec1,*Rec2;

   Rec1 = (struct TRec *)a;
   Rec2 = (struct TRec *)b;
   return strcmp(Rec1->Nazwisko,Rec2->Nazwisko);
}

struct TRec Lst[] = {{103,"Kowalski"}, {102,"Nowak"}, {104,"Tabisz"},
                     {100,"Madonna"}, {107,"Owsiak"}};

int cmp(const void *a, const void *b)
{
   return *(int *)a - *(int *)b;
}

/*
qsort(c, n, sizeof(int), cmp);
qsort(void *base, size_t nmemb, size_t size,
                  int(*compar)(const void *, const void *));
*/

void sortW(int n, int *T)
{
   int i,j,k,a;

   for(i=0; i<n; i=i+1)
   {
      a = T[i];
      k = i;
      for(j=i; j<n; j=j+1)
      {
         if( T[j]<a )
         {
            a = c[j];
            k = j;
         }
      }
      T[k] = T[i];
      T[i] = a;
   }
}

/* sortowanie przez proste wybieranie */
void sortWuni(void *base, size_t nmemb, size_t size,
                  int(*compar)(const void *, const void *))
{
   char *baseChar;
   void *a;
   int i,j,k;

   baseChar = (char *)base;
   a = malloc(size);
   for(i=0; i<nmemb; i=i+1)
   {
//      a = T[i];
      memmove(a, baseChar+i*size, size);
      k = i;
      for(j=i; j<nmemb; j=j+1)
      {
         if( (*compar)(baseChar+j*size, a)<0 )
         {
//             a = T[j];
            memmove(a, baseChar+j*size, size);
            k = j;
         }
      }
//      T[k] = T[i];
      memmove(baseChar+k*size, baseChar+i*size, size);
//      T[i] = a;
      memmove(baseChar+i*size,a, size);
   }
   free(a);
}

/* sortowanie babelkowe, bubblesort */
void sortBuni(void *base, size_t nmemb, size_t size,
                  int(*compar)(const void *, const void *))
{
   char *baseChar;
   void *a;
   int i,j;

   baseChar = (char *)base;
   a = malloc(size);
   for(i=0; i<nmemb; i=i+1)
   {
      for(j=1; j<nmemb-i; j=j+1)
      {
//         if( c[j-1]>c[j] )
         if( (*compar)(baseChar+(j-1)*size, baseChar+j*size)>0 )
         {
//            a      = c[j-1];
            memmove(a, baseChar+(j-1)*size, size);
//            c[j-1] = c[j];
            memmove(baseChar+(j-1)*size, baseChar+j*size, size);
//            c[j]   = a;
            memmove(baseChar+j*size,a, size);
         }
      }
   }
   free(a);
}

int main()
{
   int i,j,n,a;

   n = sizeof(c)/sizeof(c[0]);

   for(i=0; i<n; i=i+1)
   {
      printf("%i ", c[i]);
   }
   puts("");
/*
   for(i=0; i<n; i=i+1)
   {
      for(j=1; j<n-i; j=j+1)
      {
         if( c[j-1]>c[j] )
         {
            a      = c[j-1];
            c[j-1] = c[j];
            c[j]   = a;
         }
      }
   }
*/
//   sortBuni(c, n, sizeof(int), cmp);
   sortWuni(c, n, sizeof(int), cmp);
//   qsort(c, n, sizeof(int), cmp);
//   sortW(n, c);


   for(i=0; i<n; i=i+1)
   {
      printf("%i ", c[i]);
   }
   puts("\n");
   n = sizeof(Lst)/sizeof(Lst[0]);
   for(i=0; i<n; i=i+1)
   {
      printf("%4i  %20s\n", (Lst+i)->NrInd, (Lst+i)->Nazwisko);
   }
   puts("-1----------------------------");

   qsort(Lst, n, sizeof(Lst[0]), cmpInd);

   for(i=0; i<n; i=i+1)
   {
      printf("%4i  %20s\n", (Lst+i)->NrInd, (Lst+i)->Nazwisko);
   }
   puts("-2---------------------------");

//    sortWuni(Lst, n, sizeof(Lst[0]), cmpNa);
   sortBuni(Lst, n, sizeof(Lst[0]), cmpNa);
//    qsort(Lst, n, sizeof(Lst[0]), cmpNa);

   for(i=0; i<n; i=i+1)
   {
      printf("%4i  %20s\n", (Lst+i)->NrInd, (Lst+i)->Nazwisko);
   }
   puts("-3---------------------------");

   return 0;
}
